/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.xfw.pa.util;

import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.pa.util.FileGrowingException;
import com.ibm.hwmca.xfw.pa.util.FileInfo;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;

public class DirectorySpy {
    private static final String TRACE_MASKT = "XPAFLIST";
    private static final String TRACE_MASKF = "XPAFLISF";
    private static final String TRACE_MASKD = "XPAFLISD";

    public static void main(String[] args) {
        int sampleInterval = 5;
        int loopCount = 12;
        int growCount = 4;
        File[] fileList = null;
        if (args.length > 0) {
            Integer value;
            String directory = args[0];
            if (args.length > 1) {
                value = new Integer(args[1]);
                sampleInterval = value;
            }
            if (args.length > 2) {
                value = new Integer(args[2]);
                loopCount = value;
            }
            if (args.length > 3) {
                value = new Integer(args[3]);
                growCount = value;
            }
            Trace.trace(TRACE_MASKD, "sampleInterval = " + sampleInterval);
            Trace.trace(TRACE_MASKD, "loopCount =" + loopCount);
            Trace.trace(TRACE_MASKD, "growCount =" + growCount);
            try {
                fileList = DirectorySpy.waitOn(new File(directory), sampleInterval, loopCount, growCount);
            }
            catch (FileGrowingException e) {
                Trace.trace(TRACE_MASKD, "the file was still growing when it timed out");
            }
            if (fileList != null && fileList.length != 0) {
                Trace.trace(TRACE_MASKD, "log the file names here");
                for (int i = 0; i < fileList.length; ++i) {
                    Trace.trace(TRACE_MASKD, "file [" + i + "]'s name is" + fileList[i].getAbsolutePath());
                }
            }
        } else {
            System.out.println("you didn't specify the File to monitor");
        }
    }

    public DirectorySpy() {
        Trace.trace(TRACE_MASKF, "DirectorySpy.ctor()");
    }

    public static File[] waitOn(File file, int sampleTime, int waitCount, int growCount) throws FileGrowingException {
        return DirectorySpy.waitOn(file, null, sampleTime, waitCount, growCount);
    }

    public static File[] waitOn(File file, File[] inputList, int sampleTime, int waitCount, int growCount) throws FileGrowingException {
        File[] fileList = null;
        long fileLength = 0L;
        ArrayList returnFileList = null;
        if (file != null) {
            if (file.isDirectory()) {
                File[] initFileList = null;
                initFileList = inputList != null ? inputList : file.listFiles();
                Trace.trace(TRACE_MASKD, "initFileList.length :" + initFileList.length);
                for (int i = 0; i < waitCount; ++i) {
                    try {
                        Thread.sleep(sampleTime * 1000);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    File[] newList = file.listFiles();
                    Trace.trace(TRACE_MASKD, "new length is" + newList.length);
                    fileList = DirectorySpy.compareList(initFileList, newList);
                    if (fileList.length != 0) {
                        Trace.trace(TRACE_MASKD, "got " + fileList.length + " new files.");
                        break;
                    }
                    Trace.trace(TRACE_MASKD, "no new files");
                }
                try {
                    returnFileList = DirectorySpy.checkForGrowingFiles(fileList, sampleTime, waitCount, growCount);
                }
                catch (FileGrowingException e) {
                    Trace.trace(TRACE_MASKT, "no files were able to grow ");
                    throw e;
                }
            }
            Trace.trace(TRACE_MASKD, "waiting on file " + file.getAbsolutePath());
            File[] file2check = new File[]{file};
            Object returnFiles = null;
            try {
                returnFileList = DirectorySpy.checkForGrowingFiles(fileList, sampleTime, waitCount, growCount);
            }
            catch (FileGrowingException e) {
                Trace.trace(TRACE_MASKT, "no files were able to grow ");
                throw e;
            }
        }
        if (returnFileList != null) {
            Trace.trace(TRACE_MASKD, "Returning " + returnFileList.size() + " files");
        } else {
            Trace.trace(TRACE_MASKD, "Return no files");
        }
        File[] returnFileArray = new File[returnFileList.size()];
        Iterator rfI = returnFileList.iterator();
        int index = 0;
        while (rfI.hasNext()) {
            returnFileArray[index] = (File)rfI.next();
            ++index;
        }
        return returnFileArray;
    }

    private static void logFile(String theFile) {
    }

    private static File[] compareList(File[] list1, File[] list2) {
        ArrayList<File> arrayFileList = new ArrayList<File>();
        Trace.trace(TRACE_MASKD, "dump the files");
        Trace.trace(TRACE_MASKD, "length 1 is=" + list1.length);
        Trace.trace(TRACE_MASKD, "length 2 is=" + list2.length);
        boolean same = Arrays.equals(list1, list2);
        if (same) {
            Trace.trace(TRACE_MASKD, "the array are the same");
        } else {
            Trace.trace(TRACE_MASKD, "they are not");
            int fileFoundCount = 0;
            for (int i = list2.length - 1; i >= 0; --i) {
                Trace.trace(TRACE_MASKD, "looking for file named " + list2[i]);
                File a = list2[i];
                boolean foundIt = false;
                for (int j = 0; j < list1.length; ++j) {
                    if (!a.equals(list1[j])) continue;
                    foundIt = true;
                    break;
                }
                if (!foundIt) {
                    Trace.trace(TRACE_MASKD, "didn't find the name " + list2[i]);
                    arrayFileList.add(a);
                    ++fileFoundCount;
                }
                foundIt = false;
            }
        }
        Trace.trace(TRACE_MASKD, "returning " + arrayFileList.size() + " elements");
        return arrayFileList.toArray(new File[arrayFileList.size()]);
    }

    public static ArrayList checkForGrowingFiles(File[] fileList, int sampleTime, int waitCount, int growCount) throws FileGrowingException {
        ArrayList<File> returnFiles = new ArrayList<File>();
        boolean stopped = false;
        ArrayList<FileInfo> fileNPath2waiton = new ArrayList<FileInfo>();
        for (int i = 0; i < fileList.length; ++i) {
            fileNPath2waiton.add(new FileInfo(fileList[i], fileList[i].length()));
        }
        Trace.trace(TRACE_MASKD, "checkingForGrowingFiles --> ");
        Iterator fnpI = fileNPath2waiton.iterator();
        while (fnpI.hasNext()) {
            FileInfo thisFileInfo = (FileInfo)fnpI.next();
            Trace.trace(TRACE_MASKD, "waiting on file " + thisFileInfo.getFile().getAbsolutePath() + " and size = " + thisFileInfo.getFileLength());
        }
        boolean allDoneGrowing = false;
        for (int i = 0; i < waitCount && !allDoneGrowing; ++i) {
            allDoneGrowing = true;
            Iterator fnpI2 = fileNPath2waiton.iterator();
            while (fnpI2.hasNext()) {
                FileInfo file2check = (FileInfo)fnpI2.next();
                if (file2check.getFile().exists()) {
                    Trace.trace(TRACE_MASKD, "checking status of file " + file2check.getFile().getAbsolutePath());
                    long curFileLength = file2check.getFile().length();
                    if (file2check.getFileLength() < curFileLength) {
                        Trace.trace(TRACE_MASKD, "file " + file2check.getFile().getAbsolutePath() + " is growing last checked length = " + file2check.getFileLength() + " currentLength = " + curFileLength);
                        allDoneGrowing = false;
                        file2check.setGrowing(true);
                        file2check.setFileLength(curFileLength);
                        file2check.setGrowCountChecks(0);
                        Trace.trace(TRACE_MASKD, "file " + file2check.getFile().getAbsolutePath() + " is growing");
                        continue;
                    }
                    if (file2check.getGrowCountChecks() == growCount) {
                        Trace.trace(TRACE_MASKD, "file " + file2check.getFile().getAbsolutePath() + " isn't growing last checked length = " + file2check.getFileLength() + " currentLength = " + curFileLength + " we checked " + file2check.getGrowCountChecks() + " times ");
                        file2check.setGrowing(false);
                        continue;
                    }
                    allDoneGrowing = false;
                    file2check.setGrowCountChecks(file2check.getGrowCountChecks() + 1);
                    file2check.setGrowing(false);
                    Trace.trace(TRACE_MASKD, "file " + file2check.getFile().getAbsolutePath() + " appears to have stopped growing current size " + file2check.getFileLength() + " growCount checks = " + file2check.getGrowCountChecks());
                    continue;
                }
                Trace.trace(TRACE_MASKD, "The file doesn't exist.");
            }
            if (allDoneGrowing) continue;
            Trace.trace(TRACE_MASKD, " checking for growing files wait another time; go to sleep");
            try {
                Thread.sleep(sampleTime * 1000);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        Trace.trace(TRACE_MASKD, "end of wait loop");
        Trace.trace(TRACE_MASKD, "growing is " + allDoneGrowing);
        Iterator fnpI3 = fileNPath2waiton.iterator();
        while (fnpI3.hasNext()) {
            FileInfo fi = (FileInfo)fnpI3.next();
            if (!fi.isGrowing()) {
                returnFiles.add(fi.getFile());
                Trace.trace(TRACE_MASKD, "file was done growing and was added to our list " + fi.getFile().getAbsolutePath());
                continue;
            }
            Trace.trace(TRACE_MASKD, "file was not done growing it won't be looked at" + fi.getFile().getAbsolutePath());
        }
        if (returnFiles.size() == 0) {
            throw new FileGrowingException("all Files were still growing or never started? ");
        }
        Trace.trace(TRACE_MASKD, "<-- checkForGrowingFiles");
        return returnFiles;
    }
}

